/**
 * Klasse Grid
 * 
 * 	Definiert eine grbere Einteilung des Modellkoordinatensystems in ein aus quadratischen Zellen
 *  aufgebautes Gitternetz mit fester Kantenlnge.
 *  Zweck dieser Konstruktion ist den Suche nach anderen Boids oder Hindernissen auf gewisse Zellen
 *  dieses Gitternetzes zubeschrnken, anstatt alle Elemente betrachten zu mssen.
 *  
 * Attribute
 * 	
 * 	gridBorderFar {float[3]} entfernte (links, unten, hinten) Ecke des die Szenerie begrenzenden Quaders
 * 	gridBorderNear {float[3]} nahe (rechts, oben, vorne) Ecke des die Szenerie begrenenden Quaders
 * 	gridLength {int[3} Anzahl Zellen in den Richtungen der jewailigen Koordinatenachsen
 * 	gridCellWidth {float} Kantenlnge der Zellen im Gitternetz
 * 	data {GridCell[][][]} 3-dimensionales Feld zur Ablage der Zellen des Gitternetzes	
 * 
 * 
 */


/**
 * Grid(gridBorderFar, gridBorderNear, gridCellWidth) : Grid
 * 
 * 	Konstruktur und zugleich Definition der Klasse Grid
 * 
 * Parameter
 * 
 * 	gridBorderFar {float[3]} siehe Klassenattribute
 * 	gridBorderNear {float[3]} siehe Klassenattribute
 * 	gridCellWidth {float} siehe Klassenattribute
 * 
 * Rckgabewert
 * 
 * 	{Grid} neues Grid Objekt
 * 
 */



function Grid(gridBorderFar, gridBorderNear, gridCellWidth){
    this.gridBorderFar = gridBorderFar; //unten - links - hinten
    this.gridBorderNear = gridBorderNear; //oben - rechts - vorne
    this.gridLength = []; //Anzahl Zellen in x/y/z Richtung
    this.gridCellWidth = gridCellWidth; //Kantenlnge der (quadratischen) Zellen
    this.data;
    
    //initiales Grid erzeugen
    this.initGrid();
};

/**
 * Methode initGrid() : void
 * 
 * 	erzeugt die initiale Datenstruktur des Gitternetzes
 * 
 * Klassenmethode zu Grid
 * 
 */

Grid.prototype.initGrid = function(){	 
	 //Anzahl der Zellen pro Koordinatenachse ermitteln - gridCellWidth gibt dabei die Breite der Zellen an
	this.gridLength[0] = Math.ceil(Math.abs(this.gridBorderNear[0] - this.gridBorderFar[0]) / this.gridCellWidth);
	this.gridLength[1] = Math.ceil(Math.abs(this.gridBorderNear[1] - this.gridBorderFar[1]) / this.gridCellWidth);
	this.gridLength[2] = Math.ceil(Math.abs(this.gridBorderNear[2] - this.gridBorderFar[2]) / this.gridCellWidth);
	 
	this.data = new Array(this.gridLength[0]);
	 for(var i=0, maxi = this.gridLength[0]; i<maxi; i++){
		 this.data[i] = new Array(this.gridLength[1]);
		 for(var j=0, maxj = this.gridLength[1]; j<maxj; j++){
			 this.data[i][j] = new Array(this.gridLength[2]);
			 for(var k=0, maxk = this.gridLength[2]; k<maxk; k++){
				 this.data[i][j][k] = new GridCell(i,j,k);
			 }
		 }
	 }
};


/**
 * Methode updateGrid(items) : void
 * 
 * 	Boids in items werden in die Zellen des Gitternetz einsortiert, dabei werden nur Boids bercksichtigt die auch
 * 	als aktiv markiert sind, also mit .isAlive = true
 * 
 * Parameter
 * 
 * 	items {Boid[]} Feld mit den einzusortierenden Boids
 * 
 * 
 * Klassenmethode zu Grid
 * 
 */
Grid.prototype.updateGrid = function(items){
	
	var offsetX = this.gridBorderFar[0];
	var offsetY = this.gridBorderFar[1];
	var offsetZ = this.gridBorderFar[2];
	 
	var gridPos = [];
	if(items){ 
		for(var i=0, max = items.length; i<max; i++){
			if(items[i].isAlive){
				//aus aktueller Position des Items die position im Grid errechnen
				gridPos[0] = Math.floor((items[i].position[0] - offsetX)/this.gridCellWidth);
				gridPos[1] = Math.floor((items[i].position[1] - offsetY)/this.gridCellWidth);
				gridPos[2] = Math.floor((items[i].position[2] - offsetZ)/this.gridCellWidth);
			 
				//Item in Grid eintragen und im Item Verweis auf Gridzelle setzen
				this.data[gridPos[0]][gridPos[1]][gridPos[2]].addItem(items[i]);
				items[i].gridCell = this.data[gridPos[0]][gridPos[1]][gridPos[2]];
			}
		}
	}
};

/**
 * Methode clearGrid() : void
 * 
 * 	Setzt in smtlichen Zellen des Gitternetzes das Attribut itemCount auf 0 zurck, 
 * 	Hindernisse sind davon nicht betroffen, da diese nur einmalig eingefgt werden und
 * 	keine Vernderung erfahren
 * 
 * Klassenmethode zu Grid
 * 
 */

Grid.prototype.clearGrid = function(){
	for(var i=0, maxi = this.gridLength[0]; i<maxi; i++){
		for(var j=0, maxj = this.gridLength[1]; j<maxj; j++){
			for(var k=0, maxk = this.gridLength[2]; k<maxk; k++){
				this.data[i][j][k].itemCount = 0;
			}
		}
	}
};